<?php defined('BASEPATH') OR exit('No direct script access allowed');
class Install extends CI_Controller {
	var $title = 'Configuration Script';
	
	//these are set in the constructor
	var $databases = array();
	var $database_schema = array();
	var $mail_database_schema = array();
	var $nhindconfig_database_schema = array();
	var $database_queries = array();
	var $database_table_queries = array();
	var $ldap_schema = array();
	var $ldap_base_domain = '';
	
	//we pull our database configuration from constants and use it like CI would,
	//but we don't use the CI Database class in this install script due to the difficulty
	//in getting useful error messages when running multiple queries, which is necessary for creating the tables
	var $db_required_permissions = array('db_datareader' => FALSE, 'db_datawriter' => FALSE);
	var $database_servername = DATABASE_HOSTNAME;
	var $database_config = array (
									'UID'				=> DATABASE_USERNAME,
									'PWD'				=> DATABASE_PASSWORD,
									'Database'			=> 'master',
									'ConnectionPooling' => 0,
									'ReturnDatesAsStrings' => 1,
									'LoginTimeout' => 5,
								  );
								  
	public function __construct(){
		global $installer;
		$installer = TRUE;
		parent::__construct();
		$this->config->set_item('sess_use_database', FALSE);
		$this->config->set_item('sess_encrypt_cookie', FALSE);
		$this->load->library(array('session','encrypt'));
		$this->load->helper('url');
		
		//for now the tables will be created in the order they are put in this array,
		//keep that in mind when setting up foreign key relations, etc.
		//TO-DO: Include array sorting function for preferred creation order
		$this->database_schema =  array( 
									'users' =>	array(
													'user_id' => 'bigint',
													'username' => 'varchar(50)',
													'user_org_id' => 'bigint',
													'user_created_time' => 'bigint',
													'user_ext_mail' => 'nvarchar(max)',
													'user_ep' => 'nvarchar(max)',
												),
									'account_request' => array(
													'id' => 'bigint',
													'username' => 'varchar(100)',
													'user_org_id' => 'bigint',
													'first_name' => 'nvarchar(100)',
													'middle_name' => 'nvarchar(100)',
													'last_name' => 'nvarchar(100)',
													'ext_mail' => 'nvarchar(200)',
													'title' => 'nvarchar(300)',
													'department' => 'nvarchar(300)',
													'organization' => 'nvarchar(300)',
													'location' => 'nvarchar(500)',
													'facility_id' => 'bigint',
													'telephone' => 'nvarchar(100)',
													'mobile' => 'nvarchar(100)',
													'request_date' => 'bigint',
													'approved_date' => 'bigint',
													'justification' => 'varchar(4000)',
													'denied' => 'tinyint',
												),
									'application' =>	array(
															'id' => 'bigint',
															'name' => 'varchar(100)',
															'public_key' => 'varchar(100)',
															'private_key' => 'varchar(100)',
															'url' => 'varchar(1000)',
															'description' => 'varchar(4000)',
															'poc_name' => 'varchar(500)',
															'poc_email' => 'varchar(100)',
															'poc_phone' => 'varchar(20)',
															'app_request_id' => 'bigint'
														),
									'application_account_link'	=>	array(
																		'id' => 'bigint',
																		'app_id' => 'bigint',
																		'unique_id' => 'varchar(64)',
																		'created_at' => 'bigint',
																		'org_id' => 'bigint',
																		'system_permissions' => 'nvarchar(100)'
																	),
									'application_request' =>	array(
																	'id' => 'bigint',
																	'name' => 'varchar(100)',
																	'requestor' => 'bigint',
																	'url' => 'varchar(1000)',
																	'description' => 'varchar(4000)',
																	'poc_name' => 'varchar(500)',
																	'poc_email' => 'varchar(100)',
																	'poc_phone' => 'varchar(20)',
																	'requested_date' => 'bigint',
																	'approved_date' => 'bigint',
																	'justification' => 'varchar(4000)',
																	'denial_reason' => 'varchar(4000)',
																	'denied' => 'tinyint',
																),
									'event_log'	=>	array(
														'id' => 'bigint',
														'target_type' => 'int',
														'target_id' => 'bigint',
														'actor_type' => 'int',
														'actor_id' => 'bigint',
														'action' => 'nvarchar(max)',
														'event_date' => 'bigint',
														'success' => 'tinyint',
													),
									'facility' =>	array(
														'id' => 'bigint',
														'name' => 'varchar(400)',
														'active' => 'tinyint',
													),
									'logins' =>	array(
													'id' => 'bigint',
													'session_id' => 'nvarchar(50)',
													'ip_address' => 'nvarchar(50)',
													'login_time' => 'bigint',
													'success' => 'tinyint',
													'error_msg' => 'nvarchar(max)',
													'org_id' => 'bigint',
												),
									'mail_log' =>	array(
														'id' => 'bigint',
														'time' => 'bigint',
														'size' => 'bigint',
														'sender' => 'varchar(max)',
														'recipient' => 'varchar(max)',
														'attachment_types' => 'nvarchar(max)',
														'success' => 'tinyint',
														'inbound_outbound' => 'tinyint',
														'mdn' => 'tinyint',
													),
									'mailbox_settings' =>	array(
																'id' => 'bigint',
																'mailbox_id' => 'bigint',
																'application_id' => 'bigint',
																'web_service_id' => 'bigint',
																'authorized' => 'tinyint',
															),
									'request' =>	array(
														'id' => 'bigint',
														'application_id' => 'bigint',
														'call' => 'varchar(max)',
														'call_date' => 'bigint',
														'response_code' => 'int',
														'response' => 'varchar(max)',
													),
									'ticket_category' =>	array(
																'id' => 'bigint',
																'category' => 'varchar(200)',
															),
									'tickets' =>	array(
														'id' => 'bigint',
														'parent_id' => 'bigint',
														'user_id' => 'bigint',
														'message' => 'varchar(4000)',
														'open_date' => 'bigint',
														'close_date' => 'bigint',
														'category_id' => 'bigint',
													),
									'web_services' =>	array(
															'id' => 'bigint',
															'name' => 'varchar(200)',
															'description' => 'varchar(4000)',
														),
									'role_permissions' =>	array(
																'id' => 'bigint',
																'role_name' => 'varchar(150)',
																'permission_id' => 'bigint',
														),
									'permissions' =>	array(
																'id' => 'bigint',
																'name' => 'varchar(100)',
																'parent_id' => 'bigint',
														),
									);
		$this->mail_database_schema =  array(
											'mailboxes' => array(
												'id' => 'bigint',
												'name' => 'varchar(100)',
												'is_group' => 'tinyint',
												'is_active' => 'tinyint',
												'facility_id' => 'bigint',
											),
											'folders' => array(
												'id' => 'bigint',
												'name' => 'varchar(200)',
												'mailbox_id' => 'bigint',
											),
											'messages' => array(
												'id' => 'bigint',
												'recipients' => 'varchar(max)',
												'sender' => 'varchar(max)',
												'original_sender_id' => 'bigint',
												'to' => 'varchar(max)',
												'cc' => 'varchar(max)',
												'bcc' => 'varchar(max)',
												'attachments' => 'varchar(max)',
												'subject' => 'varchar(max)',
												'plain' => 'varchar(max)',
												'html' => 'varchar(max)',
												'timestamp' => 'bigint',
												'folder_id' => 'bigint',
												'size' => 'bigint',
												'flags' => 'varchar(max)',
												'headers' => 'varchar(max)',
												'raw_mime' => 'varchar(max)',
												'seen' => 'tinyint',
												'sent' => 'tinyint',
												'archived' => 'tinyint',
												'message_id' => 'varchar(max)',
												'mailbox_id' => 'bigint',
												'mailtype' => 'varchar(4)',
												'priority' => 'tinyint',
											),
										);
		$this->nhindconfig_database_schema = array (
												'mailet_properties' => array(
																			'name' => 'varchar(50)',
																			'value' => 'varchar(max)',
																		),
											);
		$this->database_queries = array(
									'create_' . DATABASE_NAME => 	"
																	USE [master];
																	IF NOT EXISTS(SELECT name FROM master.sys.databases WHERE name = N'api')
																	BEGIN
																	CREATE DATABASE [api]
																	ALTER DATABASE [api] SET COMPATIBILITY_LEVEL = 100

																	IF (1 = FULLTEXTSERVICEPROPERTY('IsFullTextInstalled'))
																	BEGIN
																	EXEC [api].[dbo].[sp_fulltext_database] @action = 'enable'
																	END
																	ALTER DATABASE [api] SET ANSI_NULL_DEFAULT OFF 
																	ALTER DATABASE [api] SET ANSI_NULLS OFF 
																	ALTER DATABASE [api] SET ANSI_PADDING OFF 
																	ALTER DATABASE [api] SET ANSI_WARNINGS OFF 
																	ALTER DATABASE [api] SET ARITHABORT OFF 
																	ALTER DATABASE [api] SET AUTO_CLOSE OFF 
																	ALTER DATABASE [api] SET AUTO_CREATE_STATISTICS ON 
																	ALTER DATABASE [api] SET AUTO_SHRINK OFF 
																	ALTER DATABASE [api] SET AUTO_UPDATE_STATISTICS ON 
																	ALTER DATABASE [api] SET CURSOR_CLOSE_ON_COMMIT OFF 
																	ALTER DATABASE [api] SET CURSOR_DEFAULT  GLOBAL 
																	ALTER DATABASE [api] SET CONCAT_NULL_YIELDS_NULL OFF 
																	ALTER DATABASE [api] SET NUMERIC_ROUNDABORT OFF 
																	ALTER DATABASE [api] SET QUOTED_IDENTIFIER OFF 
																	ALTER DATABASE [api] SET RECURSIVE_TRIGGERS OFF 
																	ALTER DATABASE [api] SET  DISABLE_BROKER 
																	ALTER DATABASE [api] SET AUTO_UPDATE_STATISTICS_ASYNC OFF 
																	ALTER DATABASE [api] SET DATE_CORRELATION_OPTIMIZATION OFF 
																	ALTER DATABASE [api] SET TRUSTWORTHY OFF 
																	ALTER DATABASE [api] SET ALLOW_SNAPSHOT_ISOLATION OFF 
																	ALTER DATABASE [api] SET PARAMETERIZATION SIMPLE 
																	ALTER DATABASE [api] SET READ_COMMITTED_SNAPSHOT OFF 
																	ALTER DATABASE [api] SET HONOR_BROKER_PRIORITY OFF 
																	ALTER DATABASE [api] SET  READ_WRITE 
																	ALTER DATABASE [api] SET RECOVERY FULL 
																	ALTER DATABASE [api] SET  MULTI_USER
																	ALTER DATABASE [api] SET PAGE_VERIFY CHECKSUM  
																	ALTER DATABASE [api] SET DB_CHAINING OFF
																	END
																	",
									'create_' . MAIL_DATABASE_NAME => "
																	USE [master];
																	IF NOT EXISTS(SELECT name FROM master.sys.databases WHERE name = N'mail')
																	BEGIN
																	CREATE DATABASE [mail]
																	ALTER DATABASE [mail] SET COMPATIBILITY_LEVEL = 100

																	IF (1 = FULLTEXTSERVICEPROPERTY('IsFullTextInstalled'))
																	BEGIN
																	EXEC [mail].[dbo].[sp_fulltext_database] @action = 'enable'
																	END
																	ALTER DATABASE [mail] SET ANSI_NULL_DEFAULT OFF 
																	ALTER DATABASE [mail] SET ANSI_NULLS OFF 
																	ALTER DATABASE [mail] SET ANSI_PADDING OFF 
																	ALTER DATABASE [mail] SET ANSI_WARNINGS OFF 
																	ALTER DATABASE [mail] SET ARITHABORT OFF 
																	ALTER DATABASE [mail] SET AUTO_CLOSE OFF 
																	ALTER DATABASE [mail] SET AUTO_CREATE_STATISTICS ON 
																	ALTER DATABASE [mail] SET AUTO_SHRINK OFF 
																	ALTER DATABASE [mail] SET AUTO_UPDATE_STATISTICS ON 
																	ALTER DATABASE [mail] SET CURSOR_CLOSE_ON_COMMIT OFF 
																	ALTER DATABASE [mail] SET CURSOR_DEFAULT  GLOBAL 
																	ALTER DATABASE [mail] SET CONCAT_NULL_YIELDS_NULL OFF 
																	ALTER DATABASE [mail] SET NUMERIC_ROUNDABORT OFF 
																	ALTER DATABASE [mail] SET QUOTED_IDENTIFIER OFF 
																	ALTER DATABASE [mail] SET RECURSIVE_TRIGGERS OFF 
																	ALTER DATABASE [mail] SET  DISABLE_BROKER 
																	ALTER DATABASE [mail] SET AUTO_UPDATE_STATISTICS_ASYNC OFF 
																	ALTER DATABASE [mail] SET DATE_CORRELATION_OPTIMIZATION OFF 
																	ALTER DATABASE [mail] SET TRUSTWORTHY OFF 
																	ALTER DATABASE [mail] SET ALLOW_SNAPSHOT_ISOLATION OFF 
																	ALTER DATABASE [mail] SET PARAMETERIZATION SIMPLE 
																	ALTER DATABASE [mail] SET READ_COMMITTED_SNAPSHOT OFF 
																	ALTER DATABASE [mail] SET HONOR_BROKER_PRIORITY OFF 
																	ALTER DATABASE [mail] SET  READ_WRITE 
																	ALTER DATABASE [mail] SET RECOVERY FULL 
																	ALTER DATABASE [mail] SET  MULTI_USER
																	ALTER DATABASE [mail] SET PAGE_VERIFY CHECKSUM  
																	ALTER DATABASE [mail] SET DB_CHAINING OFF
																	END
																	",
									'encrypt_'.MAIL_DATABASE_NAME => 	"
																		USE [master]
																		IF (select Count(*) from sys.symmetric_keys where name like '%DatabaseMasterKey%') = 0
																		BEGIN
																		create master key encryption by password = '".$this->config->item('encryption_key')."';
																		END

																		IF (select Count(*) from sys.certificates where name = 'TDE_Certificate') = 0
																		BEGIN
																		create certificate TDE_Certificate with subject = 'Database TDE certificate';
																		END

																		IF (select Count(*) from sys.certificates where name = 'TDE_Certificate') > 0
																		BEGIN
																		USE [mail]
																		CREATE DATABASE ENCRYPTION KEY
																		WITH ALGORITHM = AES_256
																		ENCRYPTION BY SERVER CERTIFICATE TDE_Certificate
																		ALTER DATABASE mail SET ENCRYPTION ON
																		END
																		",
									'create_nhindconfig' => 	"
																	USE [master];
																	IF NOT EXISTS(SELECT name FROM master.sys.databases WHERE name = N'nhindconfig')
																	BEGIN
																	CREATE DATABASE [nhindconfig]
																	ALTER DATABASE [nhindconfig] SET COMPATIBILITY_LEVEL = 100

																	IF (1 = FULLTEXTSERVICEPROPERTY('IsFullTextInstalled'))
																	BEGIN
																	EXEC [nhindconfig].[dbo].[sp_fulltext_database] @action = 'enable'
																	END
																	ALTER DATABASE [nhindconfig] SET ANSI_NULL_DEFAULT OFF 
																	ALTER DATABASE [nhindconfig] SET ANSI_NULLS OFF 
																	ALTER DATABASE [nhindconfig] SET ANSI_PADDING OFF 
																	ALTER DATABASE [nhindconfig] SET ANSI_WARNINGS OFF 
																	ALTER DATABASE [nhindconfig] SET ARITHABORT OFF 
																	ALTER DATABASE [nhindconfig] SET AUTO_CLOSE OFF 
																	ALTER DATABASE [nhindconfig] SET AUTO_CREATE_STATISTICS ON 
																	ALTER DATABASE [nhindconfig] SET AUTO_SHRINK OFF 
																	ALTER DATABASE [nhindconfig] SET AUTO_UPDATE_STATISTICS ON 
																	ALTER DATABASE [nhindconfig] SET CURSOR_CLOSE_ON_COMMIT OFF 
																	ALTER DATABASE [nhindconfig] SET CURSOR_DEFAULT  GLOBAL 
																	ALTER DATABASE [nhindconfig] SET CONCAT_NULL_YIELDS_NULL OFF 
																	ALTER DATABASE [nhindconfig] SET NUMERIC_ROUNDABORT OFF 
																	ALTER DATABASE [nhindconfig] SET QUOTED_IDENTIFIER OFF 
																	ALTER DATABASE [nhindconfig] SET RECURSIVE_TRIGGERS OFF 
																	ALTER DATABASE [nhindconfig] SET  DISABLE_BROKER 
																	ALTER DATABASE [nhindconfig] SET AUTO_UPDATE_STATISTICS_ASYNC OFF 
																	ALTER DATABASE [nhindconfig] SET DATE_CORRELATION_OPTIMIZATION OFF 
																	ALTER DATABASE [nhindconfig] SET TRUSTWORTHY OFF 
																	ALTER DATABASE [nhindconfig] SET ALLOW_SNAPSHOT_ISOLATION OFF 
																	ALTER DATABASE [nhindconfig] SET PARAMETERIZATION SIMPLE 
																	ALTER DATABASE [nhindconfig] SET READ_COMMITTED_SNAPSHOT OFF 
																	ALTER DATABASE [nhindconfig] SET HONOR_BROKER_PRIORITY OFF 
																	ALTER DATABASE [nhindconfig] SET  READ_WRITE 
																	ALTER DATABASE [nhindconfig] SET RECOVERY FULL 
																	ALTER DATABASE [nhindconfig] SET  MULTI_USER
																	ALTER DATABASE [nhindconfig] SET PAGE_VERIFY CHECKSUM  
																	ALTER DATABASE [nhindconfig] SET DB_CHAINING OFF
																	END
																	",
								 );
		$this->database_table_queries = array(
									DATABASE_NAME => array(
										'create_users' =>	"
															USE [".DATABASE_NAME."]
															IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[users]') AND type in (N'U'))
															BEGIN
															CREATE TABLE [dbo].[users](
																[user_id] [bigint] IDENTITY(1,1) NOT NULL,
																[username] [varchar](50) NOT NULL,
																[user_org_id] [bigint] NOT NULL,
																[user_created_time] [bigint] NOT NULL,
																[user_ext_mail] [nvarchar](max) NULL,
																[user_ep] [nvarchar](max) NOT NULL,
															PRIMARY KEY CLUSTERED ([user_id] ASC)
															WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]) ON [PRIMARY]			
															ALTER TABLE [dbo].[users] ADD CONSTRAINT [unique_user_org_id] UNIQUE NONCLUSTERED ([user_org_id])
															END
															",
										'create_application_request' => 	"
																		USE [".DATABASE_NAME."]
																		IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[application_request]') AND type in (N'U'))
																		CREATE TABLE [dbo].[application_request](
																			[id] [bigint] IDENTITY(1,1) NOT NULL,
																			[name] [varchar](100) NULL,
																			[requestor] [bigint] NOT NULL,
																			[url] [varchar](1000) NULL,
																			[description] [varchar](4000) NULL,
																			[poc_name] [varchar](500) NULL,
																			[poc_email] [varchar](100) NULL,
																			[poc_phone] [varchar](20) NULL,
																			[requested_date] [bigint] NULL,
																			[approved_date] [bigint] NULL,
																			[justification] [varchar](4000) NULL,
																			[denial_reason] [varchar](4000) NULL,
																			[denied] [tinyint] NULL,
																		PRIMARY KEY CLUSTERED ([id] ASC)
																		WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]) ON [PRIMARY]

																		IF  NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_application_request_users]') AND parent_object_id = OBJECT_ID(N'[dbo].[application_request]'))
																		BEGIN
																		ALTER TABLE [dbo].[application_request]  WITH CHECK ADD CONSTRAINT [FK_application_request_users] FOREIGN KEY([requestor])
																		REFERENCES [dbo].[users] ([user_id])
																		END
																		",
										'create_application' =>	"
																USE [".DATABASE_NAME."]
																IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[application]') AND type in (N'U'))
																CREATE TABLE [dbo].[application](
																	[id] [bigint] IDENTITY(1,1) NOT NULL,
																	[name] [varchar](100) NULL,
																	[public_key] [varchar](100) NULL,
																	[private_key] [varchar](100) NULL,
																	[url] [varchar](1000) NULL,
																	[description] [varchar](4000) NULL,
																	[poc_name] [varchar](500) NULL,
																	[poc_email] [varchar](100) NULL,
																	[poc_phone] [varchar](20) NULL,
																	[app_request_id] [bigint] NULL,
																PRIMARY KEY CLUSTERED ([id] ASC)
																WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]) ON [PRIMARY]

																IF  NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_application_application_reques]') AND parent_object_id = OBJECT_ID(N'[dbo].[application]'))
																BEGIN
																ALTER TABLE [dbo].[application]  WITH CHECK ADD CONSTRAINT [FK_application_application_request] FOREIGN KEY([app_request_id])
																REFERENCES [dbo].[application_request] ([id])
																END
																",
										'create_application_account_link' => 	"
																				USE [".DATABASE_NAME."]
																				SET ANSI_NULLS ON
																				SET QUOTED_IDENTIFIER ON
																				SET ANSI_PADDING ON

																				IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[application_account_link]') AND type in (N'U'))
																				BEGIN
																				CREATE TABLE [dbo].[application_account_link](
																					[id] [bigint] IDENTITY(1,1) NOT NULL,
																					[app_id] [bigint] NOT NULL,
																					[unique_id] [varchar](64) NOT NULL,
																					[created_at] [bigint] NOT NULL,
																					[org_id] [bigint] NULL,
																				 CONSTRAINT [PK_application_account_link] PRIMARY KEY CLUSTERED ([id] ASC)
																				WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]) ON [PRIMARY]
																				END
																				SET ANSI_PADDING OFF

																				IF  NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_application_account_link_application]') AND parent_object_id = OBJECT_ID(N'[dbo].[application_account_link]'))
																				BEGIN
																				ALTER TABLE [dbo].[application_account_link]  WITH CHECK ADD CONSTRAINT [FK_application_account_link_application] FOREIGN KEY([app_id])
																				REFERENCES [dbo].[application] ([id])
																				END
																				",
										'create_account_request' =>	"
																	USE [".DATABASE_NAME."]
																	IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[account_request]') AND type in (N'U'))
																	BEGIN
																	CREATE TABLE [dbo].[account_request](
																		[id] [bigint] IDENTITY(1,1) NOT NULL,
																		[username] [varchar](100) NULL,
																		[user_org_id] [bigint] NOT NULL,
																		[first_name] [nvarchar](100) NOT NULL,
																		[middle_name] [nvarchar](100) NULL,
																		[last_name] [nvarchar](100) NOT NULL,
																		[ext_mail] [nvarchar](200) NULL,
																		[title] [nvarchar](300) NULL,
																		[department] [nvarchar](300) NULL,
																		[organization] [nvarchar](300) NULL,
																		[location] [nvarchar](500) NULL,
																		[facility_id] [bigint] NULL,
																		[telephone] [nvarchar](100) NULL,
																		[mobile] [nvarchar](100) NULL,
																		[request_date] [bigint] NOT NULL,
																		[approved_date] [bigint] NULL,
																		[justification] [varchar](4000) NULL,
																		[denied] [tinyint] NOT NULL,
																	PRIMARY KEY CLUSTERED ([id] ASC)
																	WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]) ON [PRIMARY]
																	END
																	",
										'create_event_log' =>	"
																USE [".DATABASE_NAME."]
																SET ANSI_NULLS ON
																SET QUOTED_IDENTIFIER ON
																SET ANSI_PADDING ON
																IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[event_log]') AND type in (N'U'))
																BEGIN
																CREATE TABLE [dbo].[event_log](
																	[id] [bigint] IDENTITY(1,1) NOT NULL,
																	[target_type] [int] NOT NULL,
																	[target_id] [bigint] NOT NULL,
																	[actor_type] [int] NOT NULL,
																	[actor_id] [bigint] NOT NULL,
																	[action] [nvarchar](max) NOT NULL,
																	[event_date] [bigint] NOT NULL,
																	[success] [tinyint] NOT NULL,
																 CONSTRAINT [PK_event_log] PRIMARY KEY CLUSTERED ([id] ASC)
																 WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]) ON [PRIMARY]
																END
																",
										'create_facility' =>	"
																USE [".DATABASE_NAME."]
																SET ANSI_NULLS ON
																SET QUOTED_IDENTIFIER ON
																SET ANSI_PADDING ON
																IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[facility]') AND type in (N'U'))
																BEGIN
																CREATE TABLE [dbo].[facility](
																	[id] [bigint] IDENTITY(1,1) NOT NULL,
																	[name] [varchar](400) NOT NULL,
																	[active] [tinyint] NOT NULL,
																PRIMARY KEY CLUSTERED ([id] ASC)
																WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]) ON [PRIMARY]
																SET ANSI_PADDING OFF
																END
																",
										'create_logins' =>	"
															USE [".DATABASE_NAME."]
															SET ANSI_NULLS ON
															SET QUOTED_IDENTIFIER ON
															IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[logins]') AND type in (N'U'))
															BEGIN
															CREATE TABLE [dbo].[logins](
																[id] [bigint] IDENTITY(1,1) NOT NULL,
																[session_id] [nvarchar](50) NOT NULL,
																[ip_address] [nvarchar](50) NOT NULL,
																[login_time] [bigint] NOT NULL,
																[success] [tinyint] NOT NULL,
																[error_msg] [nvarchar](max) NOT NULL,
																[org_id] [bigint] NOT NULL,
															 CONSTRAINT [PK_logins] PRIMARY KEY CLUSTERED ([id] ASC)
															WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]) ON [PRIMARY]
															END
															",
										'create_mail_log' =>	"
																USE [".DATABASE_NAME."]
																SET ANSI_NULLS ON
																SET QUOTED_IDENTIFIER ON
																SET ANSI_PADDING ON
																IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[mail_log]') AND type in (N'U'))
																BEGIN
																CREATE TABLE [dbo].[mail_log](
																	[id] [bigint] IDENTITY(1,1) NOT NULL,
																	[time] [bigint] NOT NULL,
																	[size] [bigint] NOT NULL,
																	[sender] [varchar](max) NOT NULL,
																	[recipient] [varchar](max) NOT NULL,
																	[attachment_types] [nvarchar](max) NOT NULL,
																	[success] [tinyint] NOT NULL,
																	[inbound_outbound] [tinyint] NOT NULL,
																	[mdn] [tinyint] NULL,
																 CONSTRAINT [PK_mail_log] PRIMARY KEY CLUSTERED ([id] ASC)
																WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]) ON [PRIMARY]
																END
																SET ANSI_PADDING OFF
																",
										'create_mailbox_settings' =>	"
																		USE [".DATABASE_NAME."]
																		IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[mailbox_settings]') AND type in (N'U'))
																		BEGIN
																		CREATE TABLE [dbo].[mailbox_settings](
																			[id] [bigint] IDENTITY(1,1) NOT NULL,
																			[mailbox_id] [bigint] NOT NULL,
																			[application_id] [bigint] NOT NULL,
																			[web_service_id] [bigint] NOT NULL,
																			[authorized] [tinyint] NOT NULL,
																		PRIMARY KEY CLUSTERED([id] ASC)
																		WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]) ON [PRIMARY]
																		END

																		IF  NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_mailbox_settings_application]') AND parent_object_id = OBJECT_ID(N'[dbo].[mailbox_settings]'))
																		BEGIN
																		ALTER TABLE [dbo].[mailbox_settings]  WITH CHECK ADD CONSTRAINT [FK_mailbox_settings_application] FOREIGN KEY([application_id])
																		REFERENCES [dbo].[application] ([id])
																		END

																		IF  NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_mailbox_settings_web_services]') AND parent_object_id = OBJECT_ID(N'[dbo].[mailbox_settings]'))
																		BEGIN
																		ALTER TABLE [dbo].[mailbox_settings]  WITH CHECK ADD CONSTRAINT [FK_mailbox_settings_web_services] FOREIGN KEY([web_service_id])
																		REFERENCES [dbo].[web_services] ([id])
																		END
																		",
										'create_request' =>	"
															USE [".DATABASE_NAME."]
															IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[request]') AND type in (N'U'))
															BEGIN
															CREATE TABLE [dbo].[request](
																[id] [bigint] IDENTITY(1,1) NOT NULL,
																[application_id] [bigint] NULL,
																[call] [varchar](max) NULL,
																[call_date] [bigint] NULL,
																[response_code] [int] NULL,
																[response] [varchar](max) NULL,
															PRIMARY KEY CLUSTERED ([id] ASC)
															WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]) ON [PRIMARY]
															END

															IF  NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_request_application]') AND parent_object_id = OBJECT_ID(N'[dbo].[request]'))
															BEGIN
															ALTER TABLE [dbo].[request]  WITH CHECK ADD CONSTRAINT [FK_request_application] FOREIGN KEY([application_id])
															REFERENCES [dbo].[application] ([id])
															END
															",
										'create_ticket_category' => "
																	USE [".DATABASE_NAME."]
																	IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ticket_category]') AND type in (N'U'))
																	BEGIN
																	CREATE TABLE [dbo].[ticket_category](
																	[id] [bigint] IDENTITY(1,1) NOT NULL,
																	[category] [varchar](200) NULL,
																	PRIMARY KEY CLUSTERED
																	([id] ASC)
																	WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]) ON [PRIMARY]
																	END
																	
																	IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ticket_category]') AND type in (N'U'))
																	BEGIN
																	SET IDENTITY_INSERT [dbo].[web_services] ON
																	INSERT [dbo].[ticket_category] ([id], [category]) VALUES (1, N'Contact')
																	SET IDENTITY_INSERT [dbo].[web_services] OFF
																	END
																	",
										'create_tickets' =>	"
															USE [".DATABASE_NAME."]
															IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[tickets]') AND type in (N'U'))
															BEGIN
															CREATE TABLE [dbo].[tickets](
																[id] [bigint] IDENTITY(1,1) NOT NULL,
																[parent_id] [bigint] NULL,
																[user_id] [bigint] NULL,
																[message] [varchar](4000) NULL,
																[open_date] [bigint] NULL,
																[close_date] [bigint] NULL,
																[category_id] [bigint] NULL,
															PRIMARY KEY CLUSTERED ([id] ASC)
															WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]) ON [PRIMARY]
															END

															IF  NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_tickets_users]') AND parent_object_id = OBJECT_ID(N'[dbo].[tickets]'))
															BEGIN
															ALTER TABLE [dbo].[tickets]  WITH CHECK ADD CONSTRAINT [FK_tickets_users] FOREIGN KEY([user_id])
															REFERENCES [dbo].[users] ([user_id])
															END

															IF  NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_tickets_tickets]') AND parent_object_id = OBJECT_ID(N'[dbo].[tickets]'))
															BEGIN
															ALTER TABLE [dbo].[tickets]  WITH CHECK ADD CONSTRAINT [FK_tickets_tickets] FOREIGN KEY([parent_id])
															REFERENCES [dbo].[tickets] ([id])
															END

															IF  NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_tickets_ticket_category]') AND parent_object_id = OBJECT_ID(N'[dbo].[tickets]'))
															BEGIN
															ALTER TABLE [dbo].[tickets]  WITH CHECK ADD CONSTRAINT [FK_tickets_ticket_category] FOREIGN KEY([category_id])
															REFERENCES [dbo].[ticket_category] ([id])
															END
															",
										'create_web_services' =>	"
																	USE [".DATABASE_NAME."]
																	SET ANSI_NULLS ON
																	SET QUOTED_IDENTIFIER ON
																	SET ANSI_PADDING ON
																	IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[web_services]') AND type in (N'U'))
																	BEGIN
																	CREATE TABLE [dbo].[web_services](
																		[id] [bigint] IDENTITY(1,1) NOT NULL,
																		[name] [varchar](200) NOT NULL,
																		[description] [varchar](4000) NULL,
																	 CONSTRAINT [PK_web_services] PRIMARY KEY NONCLUSTERED ([id] ASC)
																	WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]) ON [PRIMARY]
																	END
																	SET ANSI_PADDING OFF

																	IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[web_services]') AND type in (N'U'))
																	BEGIN
																	SET IDENTITY_INSERT [dbo].[web_services] ON
																	INSERT [dbo].[web_services] ([id], [name], [description]) VALUES (1, N'send', N'Allows application to send a direct message on your behalf')
																	INSERT [dbo].[web_services] ([id], [name], [description]) VALUES (2, N'retrieve', N'Allows application to retrieve your messages')
																	INSERT [dbo].[web_services] ([id], [name], [description]) VALUES (3, N'manage', N'Allows application to manage messages and folders')
																	SET IDENTITY_INSERT [dbo].[web_services] OFF
																	END
																	",
											'create_permissions' =>	"
																	USE [".DATABASE_NAME."]
																	SET ANSI_NULLS ON
																	SET QUOTED_IDENTIFIER ON
																	SET ANSI_PADDING ON
																	IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[permissions]') AND type in (N'U'))
																	BEGIN
																	CREATE TABLE [dbo].[permissions](
																		[id] [bigint] IDENTITY(1,1) NOT NULL,
																		[name] [varchar](100) NOT NULL,
																		[parent_id] bigint NULL,
																	 CONSTRAINT [PK_permissions] PRIMARY KEY NONCLUSTERED ([id] ASC)
																	WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]) ON [PRIMARY]
																	END
																	SET ANSI_PADDING OFF
											
																	IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[permissions]') AND type in (N'U'))
																	BEGIN
																	SET IDENTITY_INSERT [dbo].[permissions] ON
																	INSERT [dbo].[permissions] ([id], [name], [parent_id]) VALUES (1, N'reports', NULL)
																	INSERT [dbo].[permissions] ([id], [name], [parent_id]) VALUES (2, N'user_activity_summary_report', 1)
																	INSERT [dbo].[permissions] ([id], [name], [parent_id]) VALUES (3, N'facility_report', 1)
																	SET IDENTITY_INSERT [dbo].[permissions] OFF
																	END
																	",
											'create_role_permissions' =>	"
																	USE [".DATABASE_NAME."]
																	SET ANSI_NULLS ON
																	SET QUOTED_IDENTIFIER ON
																	SET ANSI_PADDING ON
																	IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[role_permissions]') AND type in (N'U'))
																	BEGIN
																	CREATE TABLE [dbo].[role_permissions](
																		[id] [bigint] IDENTITY(1,1) NOT NULL,
																		[role_name] [varchar](150) NOT NULL,
																		[permission_id] bigint NOT NULL,
																	 CONSTRAINT [PK_role_permissions] PRIMARY KEY NONCLUSTERED ([id] ASC)
																	WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]) ON [PRIMARY]
																	END
																	SET ANSI_PADDING OFF
						
																	IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[role_permissions]') AND type in (N'U'))
																	BEGIN
																	SET IDENTITY_INSERT [dbo].[role_permissions] ON
																	INSERT [dbo].[role_permissions] ([id], [role_name], [permission_id]) VALUES (1, N'facilityleader', 1)
																	INSERT [dbo].[role_permissions] ([id], [role_name], [permission_id]) VALUES (2, N'facilityleader', 2)
																	INSERT [dbo].[role_permissions] ([id], [role_name], [permission_id]) VALUES (3, N'facilityleader', 3)
																	SET IDENTITY_INSERT [dbo].[role_permissions] OFF
																	END
																	",
									),
									MAIL_DATABASE_NAME => array(
										'create_folders' =>	"
															USE [".MAIL_DATABASE_NAME."]
															SET ANSI_NULLS ON
															SET QUOTED_IDENTIFIER ON
															SET ANSI_PADDING ON
															IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[folders]') AND type in (N'U'))
															BEGIN
															CREATE TABLE [dbo].[folders](
																[id] [bigint] IDENTITY(1,1) NOT NULL,
																[name] [varchar](200) NOT NULL,
																[mailbox_id] [bigint] NOT NULL,
															 CONSTRAINT [PK_folders] PRIMARY KEY NONCLUSTERED ([id] ASC)
															 WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]) ON [PRIMARY]
															SET ANSI_PADDING OFF
															END
															IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[folders]') AND type in (N'U'))
															BEGIN
															ALTER TABLE [dbo].[folders]  WITH CHECK ADD  CONSTRAINT [FK_folder_mailbox2] FOREIGN KEY([mailbox_id])
															REFERENCES [dbo].[mailboxes] ([id])
															ON DELETE CASCADE
															ALTER TABLE [dbo].[folders] CHECK CONSTRAINT [FK_folder_mailbox2]
															END
															",
										'create_messages' => 	"
																USE [".MAIL_DATABASE_NAME."]
																SET ANSI_NULLS ON
																SET QUOTED_IDENTIFIER ON
																SET ANSI_PADDING ON
																IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[messages]') AND type in (N'U'))
																BEGIN
																CREATE TABLE [dbo].[messages](
																	[id] [bigint] IDENTITY(1,1) NOT NULL,
																	[recipients] [varchar](max) NULL,
																	[sender] [varchar](max) NOT NULL,
																	[original_sender_id] [bigint] NULL,
																	[to] [varchar](max) NULL,
																	[cc] [varchar](max) NULL,
																	[bcc] [varchar](max) NULL,
																	[attachments] [varchar](max) NULL,
																	[subject] [varchar](max) NULL,
																	[plain] [varchar](max) NULL,
																	[html] [varchar](max) NULL,
																	[timestamp] [bigint] NOT NULL,
																	[folder_id] [bigint] NULL,
																	[size] [bigint] NULL,
																	[flags] [varchar](max) NULL,
																	[headers] [varchar](max) NOT NULL,
																	[raw_mime] [varchar](max) NULL,
																	[seen] [tinyint] NULL,
																	[draft] [tinyint] NULL,
																	[sent] [tinyint] NULL,
																	[archived] [tinyint] NULL,
																	[message_id] [varchar](max) NULL,
																	[mailbox_id] [bigint] NOT NULL,
																	[mailtype] [varchar](4) NOT NULL,
																	[priority] [tinyint] NOT NULL,
																 CONSTRAINT [PK_mailbox_username] PRIMARY KEY NONCLUSTERED ([id] ASC)
																WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]) ON [PRIMARY]
																END
																SET ANSI_PADDING OFF
																IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[messages]') AND type in (N'U'))
																BEGIN
																ALTER TABLE [dbo].[messages] ADD  DEFAULT ((0)) FOR [seen]
																ALTER TABLE [dbo].[messages] ADD  DEFAULT ((0)) FOR [draft]
																ALTER TABLE [dbo].[messages] ADD  DEFAULT ((0)) FOR [sent]
																ALTER TABLE [dbo].[messages] ADD  DEFAULT ((0)) FOR [archived]
																ALTER TABLE [dbo].[messages] ADD  DEFAULT ('html') FOR [mailtype]
																ALTER TABLE [dbo].[messages]  WITH CHECK ADD  CONSTRAINT [FK_message_mailbox] FOREIGN KEY([mailbox_id])
																REFERENCES [dbo].[mailboxes] ([id])
																ALTER TABLE [dbo].[messages] CHECK CONSTRAINT [FK_message_mailbox]
																ALTER TABLE [dbo].[messages]  WITH CHECK ADD  CONSTRAINT [FK_messages_folder] FOREIGN KEY([folder_id])
																REFERENCES [dbo].[folders] ([id])
																ON DELETE SET NULL
																ALTER TABLE [dbo].[messages] CHECK CONSTRAINT [FK_messages_folder]
																END
																",
										'create_mailboxes' =>	"
																USE [".MAIL_DATABASE_NAME."]
																SET ANSI_NULLS ON
																SET QUOTED_IDENTIFIER ON
																SET ANSI_PADDING ON
																IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[mailboxes]') AND type in (N'U'))
																BEGIN
																CREATE TABLE [dbo].[mailboxes](
																	[id] [bigint] IDENTITY(1,1) NOT NULL,
																	[name] [varchar](100) NOT NULL,
																	[is_group] [tinyint] NULL,
																	[is_active] [tinyint] NULL,
																	[facility_id] [bigint] NULL,
																 CONSTRAINT [PK_mailboxes] PRIMARY KEY NONCLUSTERED ([id] ASC)
																WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY],
																UNIQUE NONCLUSTERED ([name] ASC)
																WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]) ON [PRIMARY]
																END
																SET ANSI_PADDING OFF
																IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[mailboxes]') AND type in (N'U'))
																BEGIN
																ALTER TABLE [dbo].[mailboxes] ADD  DEFAULT ((0)) FOR [is_group]
																ALTER TABLE [dbo].[mailboxes] ADD  DEFAULT ((0)) FOR [is_active]
																END
																",
									),
									'nhindconfig' => array(
										'create_mailet_properties' =>	"
																		USE [nhindconfig]
																		SET ANSI_NULLS ON
																		SET QUOTED_IDENTIFIER ON
																		SET ANSI_PADDING ON
																		IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[mailet_properties]') AND type in (N'U'))
																		BEGIN
																		CREATE TABLE [dbo].[mailet_properties](
																			[name] [varchar](50) NOT NULL,
																			[value] [varchar](max) NULL,
																		 CONSTRAINT [PK_mailet_properties] PRIMARY KEY CLUSTERED ([name] ASC)
																		WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]) ON [PRIMARY]
																		END
																		SET ANSI_PADDING OFF
																		IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[mailet_properties]') AND type in (N'U'))
																		BEGIN
																		INSERT [dbo].[mailet_properties] ([name], [value]) VALUES (N'mail.smtp.host', N'localhost')
																		INSERT [dbo].[mailet_properties] ([name], [value]) VALUES (N'mail.smtp.port', N'587')
																		INSERT [dbo].[mailet_properties] ([name], [value]) VALUES (N'mail.transport.protocol', N'smtp')
																		INSERT [dbo].[mailet_properties] ([name], [value]) VALUES (N'mailet.db.apiname', N'".DATABASE_NAME."')
																		INSERT [dbo].[mailet_properties] ([name], [value]) VALUES (N'mailet.db.apipassword', N'".DATABASE_USERNAME."')
																		INSERT [dbo].[mailet_properties] ([name], [value]) VALUES (N'mailet.db.apiusername', N'".DATABASE_PASSWORD."')
																		INSERT [dbo].[mailet_properties] ([name], [value]) VALUES (N'mailet.db.encrypt', N'true')
																		INSERT [dbo].[mailet_properties] ([name], [value]) VALUES (N'mailet.db.hostname', N'".first_element(explode('\\',DATABASE_HOSTNAME))."')
																		INSERT [dbo].[mailet_properties] ([name], [value]) VALUES (N'mailet.db.instance', N'".first_element(explode(',',last_element(explode('\\',DATABASE_HOSTNAME))))."')
																		INSERT [dbo].[mailet_properties] ([name], [value]) VALUES (N'mailet.db.mailname', N'".MAIL_DATABASE_NAME."')
																		INSERT [dbo].[mailet_properties] ([name], [value]) VALUES (N'mailet.db.mailpassword', N'".DATABASE_USERNAME."')
																		INSERT [dbo].[mailet_properties] ([name], [value]) VALUES (N'mailet.db.mailusername', N'".DATABASE_PASSWORD."')
																		INSERT [dbo].[mailet_properties] ([name], [value]) VALUES (N'mailet.db.port', N'1433')
																		INSERT [dbo].[mailet_properties] ([name], [value]) VALUES (N'mailet.db.webname', N'direct')
																		INSERT [dbo].[mailet_properties] ([name], [value]) VALUES (N'mailet.db.webpassword', N'')
																		INSERT [dbo].[mailet_properties] ([name], [value]) VALUES (N'mailet.db.webusername', N'')
																		INSERT [dbo].[mailet_properties] ([name], [value]) VALUES (N'mailet.domain', N'".DIRECT_DOMAIN."')
																		INSERT [dbo].[mailet_properties] ([name], [value]) VALUES (N'mailet.error.folder', N'/u01/app/james-2.3.2/store/')
																		INSERT [dbo].[mailet_properties] ([name], [value]) VALUES (N'mailet.error.keypass', N'')
																		INSERT [dbo].[mailet_properties] ([name], [value]) VALUES (N'mailet.error.keystore', N'')
																		INSERT [dbo].[mailet_properties] ([name], [value]) VALUES (N'mailet.error.private', N'1')
																		INSERT [dbo].[mailet_properties] ([name], [value]) VALUES (N'mailet.error.public', N'')
																		INSERT [dbo].[mailet_properties] ([name], [value]) VALUES (N'mailet.error.refresh', N'5')
																		INSERT [dbo].[mailet_properties] ([name], [value]) VALUES (N'mailet.error.storepass', N'')
																		INSERT [dbo].[mailet_properties] ([name], [value]) VALUES (N'mailet.ldap.api', N'dc=api')
																		INSERT [dbo].[mailet_properties] ([name], [value]) VALUES (N'mailet.ldap.domain', N'".str_replace('dc=api','',LDAP_BASE_RDN)."')
																		INSERT [dbo].[mailet_properties] ([name], [value]) VALUES (N'mailet.ldap.host', N'".LDAP_HOSTNAME."')
																		INSERT [dbo].[mailet_properties] ([name], [value]) VALUES (N'mailet.ldap.password', N'".LDAP_ANON_ADMIN_PASSWORD."')
																		INSERT [dbo].[mailet_properties] ([name], [value]) VALUES (N'mailet.ldap.port', N'".LDAP_PORT."')
																		INSERT [dbo].[mailet_properties] ([name], [value]) VALUES (N'mailet.ldap.protocol', N'".((LDAP_PORT === '636') ? 'ldaps' : 'ldap')."')
																		INSERT [dbo].[mailet_properties] ([name], [value]) VALUES (N'mailet.ldap.user_dn', N'".LDAP_ANON_ADMIN_USERNAME."')
																		INSERT [dbo].[mailet_properties] ([name], [value]) VALUES (N'mailet.notification.sender', N'notifications@".DIRECT_DOMAIN."')
																		INSERT [dbo].[mailet_properties] ([name], [value]) VALUES (N'mailet.supportEmail', N'austinhelpdesk.domain')
																		END
																		",
									),
								);
		$this->databases = array(DATABASE_NAME => $this->database_schema, MAIL_DATABASE_NAME => $this->mail_database_schema, 'nhindconfig' => $this->nhindconfig_database_schema);
		$api_dn = ldap_explode_dn(LDAP_BASE_RDN, 0);
		unset($api_dn['count']);
		unset($api_dn[0]);
		$this->ldap_base_domain = implode(',',$api_dn);
		$this->ldap_schema = array(
								LDAP_BASE_RDN => array('objectClass' => array('dcObject','organization','top'),'dc'=>'api','o'=>'nodomain'),
								'ou=admin_api_apps,'.LDAP_BASE_RDN => array('objectClass' => 'groupOfNames', 'cn' => 'Admin API Enabled Applications', 'member' => 'cn=admin,'.$this->ldap_base_domain, 'ou' => 'admin_api_apps'),
								'ou=api_admins,'.LDAP_BASE_RDN => array('objectClass' => 'groupOfNames', 'cn' => 'API Admins', 'member' => 'cn=admin,'.$this->ldap_base_domain, 'ou' => 'api_admins'),
								'ou=direct_api_apps,'.LDAP_BASE_RDN => array('objectClass' => 'groupOfNames', 'cn' => 'Direct API Enabled Applications', 'member' => 'cn=admin,'.$this->ldap_base_domain, 'ou' => 'direct_api_apps'),
								'ou=disabled_accounts,'.LDAP_BASE_RDN => array('objectClass' => array('organizationalUnit','top'), 'ou' => 'disabled_accounts'),
								'ou=disabled_applications,'.LDAP_BASE_RDN => array('objectClass' => array('organizationalUnit','top'), 'ou' => 'disabled_applications'),
								'ou=disabled_groups,'.LDAP_BASE_RDN => array('objectClass' => array('organizationalUnit','top'), 'ou' => 'disabled_groups'),
								'ou=accounts,'.LDAP_BASE_RDN => array('objectClass' => array('organizationalUnit','top'), 'ou' => 'accounts'),
								'ou=applications,'.LDAP_BASE_RDN => array('objectClass' => array('organizationalUnit','top'), 'ou' => 'applications'),
								'ou=groups,'.LDAP_BASE_RDN => array('objectClass' => array('organizationalUnit','top'), 'ou' => 'groups'),
								'ou=roles,'.LDAP_BASE_RDN => array('objectClass' => array('organizationalUnit','top'), 'ou' => 'roles'),
								'ou=facilityleader,ou=roles,'.LDAP_BASE_RDN =>  array('objectClass' => 'groupOfNames','cn' => 'Group Leader', 'member' => 'cn=admin,'.$this->ldap_base_domain, 'ou' => 'groupleader'),
								'ou=groupleader,ou=roles,'.LDAP_BASE_RDN => array('objectClass' => 'groupOfNames','cn' => 'Facility Leader', 'member' => 'cn=admin,'.$this->ldap_base_domain, 'ou' => 'facilityleader'),
							);
	}
	
	public function index() {
		$this->load_install_view();
	}
	public function ldap() {
		$this->load_install_view('ldap');
	}
	public function database() {
		$this->load_install_view('database');
	}
	
	public function create_db($database = DATABASE_NAME) {
		if($this->input->post('sa_name') && $this->input->post('sa_pwd')) {
			$sa_name = $this->input->post('sa_name',TRUE);
			$sa_pwd = $this->input->post('sa_pwd',TRUE);
			$this->database_config['UID'] = $sa_name;
			$this->database_config['PWD'] = $sa_pwd;
		}
		$conn = sqlsrv_connect($this->database_servername, $this->database_config);
		if($conn) {
			$query = $this->database_queries['create_'.$database];
			$stmt = sqlsrv_query($conn, $query);
			$errors = array();
			if($stmt) {
				//check the entire query for errors, since it has multiple parts
				while(!is_null(sqlsrv_next_result($stmt))) {
					$sql_errors = sqlsrv_errors(SQLSRV_ERR_ERRORS);
					if(is_array($sql_errors)) {
						foreach($sql_errors as $error) {
							array_push($errors, $error);
						}
					}
				}
			}
			else { $errors = sqlsrv_errors(SQLSRV_ERR_ERRORS); }
			$this->session->set_flashdata('create_db_errors', $errors);
		}
		if($conn && $stmt && empty($errors)) {
			foreach($this->databases[$database] as $table => $columns) {
				$this->_create_db_table($table, $database);
			}
		}
		redirect('install/database');
	}
	
	public function create_db_table($table, $database = DATABASE_NAME) {
		$this->_create_db_table($table, $database);
		redirect('install/database');
	}
	
	public function encrypt_db($database = MAIL_DATABASE_NAME) {
		if($this->input->post('sa_name') && $this->input->post('sa_pwd')) {
			$sa_name = $this->input->post('sa_name',TRUE);
			$sa_pwd = $this->input->post('sa_pwd',TRUE);
			$this->database_config['UID'] = $sa_name;
			$this->database_config['PWD'] = $sa_pwd;
		}
		$key = $this->input->post('en_key');
		$conn = sqlsrv_connect($this->database_servername, $this->database_config);
		if($conn) {
			$query = $this->database_queries['encrypt_'.$database];
			$query = str_replace($this->config->item('encryption_key'), $key, $query);
			$stmt = sqlsrv_query($conn, $query);
			$errors = array();
			if($stmt) {
				//check the entire query for errors, since it has multiple parts
				while(!is_null(sqlsrv_next_result($stmt))) {
					$sql_errors = sqlsrv_errors(SQLSRV_ERR_ERRORS);
					if(is_array($sql_errors)) {
						foreach($sql_errors as $error) {
							array_push($errors, $error);
						}
					}
				}
			}
			else { $errors = sqlsrv_errors(SQLSRV_ERR_ERRORS); }
			$this->session->set_flashdata('encrypt_db_errors', $errors);
		}
		redirect('install/database');
	}
	
	private function _create_db_table($table, $database) {
		if($this->input->post('sa_name') && $this->input->post('sa_pwd')) {
			$sa_name = $this->input->post('sa_name',TRUE);
			$sa_pwd = $this->input->post('sa_pwd',TRUE);
			$this->database_config['UID'] = $sa_name;
			$this->database_config['PWD'] = $sa_pwd;
		}
		if(array_key_exists($table, $this->databases[$database])) {
			$conn = sqlsrv_connect($this->database_servername, $this->database_config);
			if($conn) {
				$query = $this->database_table_queries[$database]['create_'.$table];
				$stmt = sqlsrv_query($conn, $query);
				$errors = array();
				if($stmt) {
					//check the entire query for errors, since it has multiple parts
					while(!is_null(sqlsrv_next_result($stmt))) {
						$sql_errors = sqlsrv_errors(SQLSRV_ERR_ERRORS);
						if(is_array($sql_errors)) {
							foreach($sql_errors as $error) {
								array_push($errors, $error);
							}
						}
					}
					
				}
				else {
					$errors = sqlsrv_errors(SQLSRV_ERR_ERRORS);
				}
				//if we found errors
				if(!empty($errors)) {
					$this->session->set_flashdata($table.'_errors',$errors);
					$this->session->set_flashdata($table.'_query',$query);
				}
			}
			else {
				$this->session->set_flashdata($table.'_errors',sqlsrv_errors());
				$this->session->set_flashdata($table.'_query',$query);
			}
		}
		else {
			$this->session->set_flashdata($table.'_errors','This table does not exist in the configured schema.');
			$this->session->set_flashdata($table.'_query',$query);
		}
	}
	
	private function load_install_view($page = 'database') {
		$this->load->helper('form_helper');
		$this->output->append_output('
			<!doctype html>
			<html>
				<head>
					<title>'.$this->title.'</title>
				</head>
				<body>
					<div class="wrapper">
						<div class="nav">
							<a href="/install/database">Database</a>
							<a href="/install/ldap">LDAP</a>
						</div>
						<div>
		');
		if($page === 'database') { 
			$this->output->append_output('<h2>Database</h2>');
			foreach($this->databases as $database => $schema) {
				$this->output->append_output($this->db_configuration_table($database));
			}
		}
		else if($page === 'ldap') {
			$this->output->append_output('<h2>LDAP</h2>');
			$this->output->append_output($this->ldap_configuration_table());
		}
		$this->output->append_output('
						</div>
					</div>
				</body>
			</html>
		');
	}
	
	private function ldap_configuration_table() {
		$this->load->helper('form');
		$output = '';
		$ldap_dns = array();
		$ldap_conn = $this->prepare_ldap_conn();
		$ldap_bind = @ldap_bind($ldap_conn, LDAP_ANON_SEARCH_USERNAME, LDAP_ANON_SEARCH_PASSWORD);
		if($ldap_bind) {
			$search = @ldap_list($ldap_conn, $base_dn, '(objectClass=*)');
			$result = @ldap_get_entries($ldap_conn, $search);
			$output .= '<table style="border: solid black 1px;">';
			$output .= '<tr><th>Required LDAP Schema</th><th>Status</th></tr>';
			foreach($this->ldap_schema as $dn => $values) {
				if($this->ldap_entry_exists($ldap_conn, $dn)) {
					$output .= '<tr><td style="color: green;">'.$dn.'<td><td style="color: green;">&#x2714;</td></tr>';
				}
				else { $output .= '<tr><td style="color: red;">'.$dn.'<td><td style="color: red;">&#x2717;</td><td>'.form_open('/install/create_ldap_entry/'.rawurlencode(base64_encode($dn))).form_submit('create','Create').form_close().'</td></tr>'; }
			}
			$output .= '</table>';
		}
		else { $output .= '<div style="max-width: 1000px; background: #fef1ec; border: solid 1px #900; border-radius: 5px; padding: 5px; margin-bottom: 5px;">'.ldap_error($ldap_conn).'</div>'; }
		return $output;
	}
	
	private function load_ldap_view() {
		$this->output->append_output('<div>');
		$this->output->append_output('<h2>LDAP</h2>');
		$ldap_status = $this->check_ldap_configuration();
		if($ldap_status['status'] === FALSE) {
			$this->output->append_output('<div>'.$ldap_status['message'].'</div>');
			$this->output->append_output(form_open('/install/create_ldap'));
			$this->output->append_output('<div class="form" style="float: none;">');
			$this->output->append_output('<label for="sa_name">LDAP admin password</label><input type="password" id="ldap_pwd" name="ldap_pwd" /><br /><br />');
			$this->output->append_output('</div>');
			$this->output->append_output('<div class="center"><input type="submit" value="Create LDAP Entry"/></div>');
			$this->output->append_output(form_close());
		}
		else{
			$this->output->append_output('<h2>LDAP <span style="color: green;">&#x2713;</span></h2>');
		}
		$this->output->append_output('</div>');
	}
	
	private function _db_connects() {
		$connects = FALSE;
		$conn = sqlsrv_connect($this->database_servername, $this->database_config);
		if($conn) { 
			$connects = TRUE; 
			sqlsrv_close($conn);
		}
		else {
			if(sqlsrv_errors()) {
				$this->session->set_flashdata('db_connects_errors', sqlsrv_errors());
			}
		}
		return $connects;
	}
	
	private function _db_exists($database = DATABASE_NAME) {
		$conn = sqlsrv_connect($this->database_servername, $this->database_config);
		if($conn) {
			$db_exist_query = "SELECT name FROM master.sys.databases WHERE name = N'".$database."'";
			$stmt = sqlsrv_query($conn, $db_exist_query, array(), array('Scrollable'=>'buffered'));
			if($stmt) {
				$num_rows = sqlsrv_num_rows($stmt);
				if($num_rows && ($num_rows > 0)) { return TRUE; }
				//db does not exist yet, or possibly we don't have permissions to see it
				else { return FALSE; }
			}
			else {
				$errors = array();
				foreach(sqlsrv_errors() as $error) {
					array_push($errors, $error);
				}
				$this->session->set_flashdata('db_exists_errors', $errors);
			}
		}
		return FALSE;
	}
	
	private function _db_permissions_set($database = DATABASE_NAME, $user = DATABASE_USERNAME, $permissions = NULL) {
		//if permissions to check are not provided by the function call, set them from defaults
		$required_permissions = empty($permissions) ? $this->db_required_permissions : $permissions;
		$conn = sqlsrv_connect($this->database_servername, $this->database_config);
		if($conn) {
			$permission_query = "USE [".$database."]; EXEC sp_helprolemember";
			$stmt = sqlsrv_query($conn, $permission_query);
			if($stmt) {
				do {
					while($row = sqlsrv_fetch_array($stmt)) {
						if($row['MemberName'] === $user) {
							if(array_key_exists($row['DbRole'], $required_permissions)) {
								$required_permissions[$row['DbRole']] = TRUE;
							}
						}
					}
				}
				while(sqlsrv_next_result($stmt));
			}
			else {
				$this->session->set_flashdata('db_permissions_set_errors', sqlsrv_errors());
			}
		}
		//if permissions are missing, set which ones are missing in flashdata to display
		if((in_array(FALSE, $required_permissions))) {
			$missing_permissions = array();
			foreach($required_permissions as $key => $permission) {
				if(!$permission) { array_push($missing_permissions, $key); }
			}
			$this->session->set_flashdata('db_permissions_missing', $missing_permissions);
		}
		return !(in_array(FALSE, $required_permissions));
	}
	
	private function _db_encrypted($database = MAIL_DATABASE_NAME) {
		$conn = sqlsrv_connect($this->database_servername, $this->database_config);
		if($conn) {
			$db_encrypted_query = "SELECT sys.databases.name, sys.dm_database_encryption_keys.database_id, encryption_state  FROM sys.dm_database_encryption_keys JOIN sys.databases ON (sys.dm_database_encryption_keys.database_id = sys.databases.database_id) WHERE sys.dm_database_encryption_keys.encryption_state = 3 AND sys.databases.name = '".$database."'";
			$stmt = sqlsrv_query($conn, $db_encrypted_query, array(), array('Scrollable'=>'buffered'));
			if($stmt) {
				$num_rows = sqlsrv_num_rows($stmt);
				if($num_rows && ($num_rows > 0)) { return TRUE; }
				//db is not encrypted yet, or possibly we don't have permissions to see if it is
				else { return FALSE; }
			}
			else {
				$errors = array();
				foreach(sqlsrv_errors() as $error) {
					array_push($errors, $error);
				}
				$this->session->set_flashdata('db_encrypted_errors', $errors);
			}
		}
		return FALSE;
	}
	
	public function db_configuration_table($database = DATABASE_NAME) {
		$this->load->helper('form');
		$output = '';
		//check database permissions / connection / database existence
		$db_connected = $this->_db_connects();
		$db_exists = $this->_db_exists($database);
		$db_encrypted = $this->_db_encrypted($database);
		$permissions_set = $this->_db_permissions_set($database);
		
		$output .= '<h3>'.$database.'</h3>';
		//if connection calls fails
		if(!$db_connected) {
			$errors = $this->session->flashdata('db_connects_errors');
			if($errors) {
				if(is_array($errors)) {
					foreach($errors as $error) {
						if(strpos('is not able to access the database "master" under the current security context', $error['message']) >= 0) { $permission_issue = TRUE; }
						$output .= '<div style="max-width: 1000px; background: #fef1ec; border: solid 1px #900; border-radius: 5px; padding: 5px; margin-bottom: 5px;">'.$error['message'].'</div>';
					}
				}
			}
			//if errors are missing (and there had to be some if we are here), flashdata is full
			else {
				$output .= '<div style="max-width: 1000px; background: #fef1ec; border: solid 1px #900; border-radius: 5px; padding: 5px; margin-bottom: 5px;">Connection errors encountered. Refresh page for more details.</div>';
			}
			//if there is a permissions error with the master db, we can't do anything really, give all the 
			//queries necessary to set up the database as raw text for manual set-up
			if(isset($permission_issue) && $permission_issue) {
				$output .= '<div style="max-width: 1000px; background: #fef1ec; border: solid 1px #900; border-radius: 5px; padding: 5px; margin-bottom: 5px;">
							A permissions issue is preventing retrieval of information from the master database that will allow this script to determine if the required database, tables, and permissions
							exist for the configured user. This is most likely due to security restrictions that have been purposefully set in place. 
							However, it is not possible for this script to proceed with automated set-up of the database. The queries required to set up
							the database have been provided below for a database administrator to set up manually.
							</div>';
				$output .= '<h3>Create required databases</h3>';
				foreach($this->database_queries as $key => $query) {
					if(strpos('create',$key) >= 0) {
						$output .= '<pre>'.preg_replace('/[\t]+/',' ',$query).'</pre>';
					}
				}
				$output .= '<h3>Create required tables</h3>';
				foreach($this->database_table_queries[$database] as $key => $query) {
					if(strpos('create',$key) >= 0) {
						$output .= '<pre>'.preg_replace('/[\t]+/',' ',$query).'</pre>';
					}
				}
			}
		}
		//if db existence call fails
		if($db_connected && !$db_exists) {
			$errors = $this->session->flashdata('db_exists_errors') ? $this->session->flashdata('db_exists_errors') : array();
			$create_errors = $this->session->flashdata('create_db_errors') ? $this->session->flashdata('create_db_errors') : array();
			$errors = array_merge($errors, $create_errors);
			$errors = empty($errors) ? FALSE : $errors;
			if($errors) {
				if(is_array($errors)) {
					foreach($errors as $error) {
						if(strpos('permission_denied',strtolower($error['message'])) >= 0) {
							$permissions_issue = TRUE;
						}
						$output .= '<div style="max-width: 1000px; background: #fef1ec; border: solid 1px #900; border-radius: 5px; padding: 5px; margin-bottom: 5px;">'.$error['message'].'</div>';
					}
				}
			}
			//if there was a permissions issue when creating the database, allow user to try other credentials
			if(isset($permissions_issue) && $permissions_issue) {
				$output .= form_open('install/create_db/'.$database)
							.form_label('Privileged SQL User: ','sa_name')
							.form_input(array('name'=>'sa_name','id'=>'sa_name')).'<br/>'
							.form_label('Privileged SQL User Password: ','sa_pwd')
							.form_password(array('name'=>'sa_pwd','id'=>'sa_pwd')).'<br/>'
							.form_submit('create_db','Create Database')
							.form_close();
				$output .= '<div>To manually create database <span style="font-weight: bold;">'.$database.'</span> run the following query: <br />';
				$output .= '<pre>'.preg_replace('/[\t]+/',' ',$this->database_queries['create_'.$database]).'</pre></div>';
			}
			else {
				$output .= form_open('install/create_db/'.$database).form_submit('create_db','Create Database').form_close();
			}
		}
		//if the database server connects, we know the database exists, but the permissions the configured user has
		//aren't configured correctly
		if($db_connected && $db_exists && !$permissions_set) {
			$errors = $this->session->flashdata('db_permissions_set_errors');
			$missing_permissions = $this->session->flashdata('db_permissions_missing');
			if($errors) {
				if(is_array($errors)) {
					foreach($errors as $error) {
						if(strpos('not able to access database "'.$database.'"',$error['message']) >= 0) {
							$add_user_query = 'USE ['.$database.']; CREATE USER ['.DATABASE_USERNAME.'] FROM LOGIN ['.DATABASE_USERNAME.'] WITH DEFAULT_SCHEMA=[dbo];';
						}
						$output .= '<div style="max-width: 1000px; background: #fef1ec; border: solid 1px #900; border-radius: 5px; padding: 5px; margin-bottom: 5px;">'.$error['message'].'</div>';
						if(isset($add_user_query)) {
							$output .= '<div style="max-width: 1000px; background: #fef1ec; border: solid 1px #900; border-radius: 5px; padding: 5px; margin-bottom: 5px;">'
										.'An error has been detected that may indicate the configured user login has not yet been added to the ' . DATABASE_NAME . ' as a user. '
										.'Use the following query to add the configured login user to the database: <br/>'
										.'<pre>'.$add_user_query.'</pre>'
										.'</div>';
						}
					}
				}
			}
			//if errors are missing (and there had to be some if we are here), flashdata is full
			else {
				$output .= '<div style="max-width: 1000px; background: #fef1ec; border: solid 1px #900; border-radius: 5px; padding: 5px; margin-bottom: 5px;">Permissions errors encountered. Refresh page for more details.</div>';
			}
			if(!empty($missing_permissions) && $missing_permissions) {
				foreach($missing_permissions as $permission) {
					$output .= '<div style="max-width: 1000px; background: #fef1ec; border: solid 1px #900; border-radius: 5px; padding: 5px; margin-bottom: 5px;">
								The configured user: '.DATABASE_USERNAME.' is missing the '.$permission.' role.
								Use the following query to grant the required role to this user:<br/>
								<pre>USE ['.$database.']; EXEC sp_addrolemember \'db_datareader\', \''.DATABASE_USERNAME.'\';</pre>
								</div>';
				}
			}
		}
		
		if($database === MAIL_DATABASE_NAME && !$db_encrypted) {
			$errors = $this->session->flashdata('db_encrypted_errors') ? $this->session->flashdata('db_encrypted_errors') : array();
			if($errors) {
				if(is_array($errors)) {
					foreach($errors as $error) {
						if(strpos('permission_denied',strtolower($error['message'])) >= 0) {
							$permissions_issue = TRUE;
						}
						if(isset($permissions_issue) && $permissions_issue) {
							$output .= '<h4>Database Encryption Status: Unknown</h4>';
						}
						$output .= '<div style="max-width: 1000px; background: #fef1ec; border: solid 1px #900; border-radius: 5px; padding: 5px; margin-bottom: 5px;">'.$error['message'].'</div>';
					}
				}
			}
			if(isset($permissions_issue) && $permissions_issue) {
				$output .= form_open('install/encrypt_db/'.$database)
							.form_label('Encryption Key','en_key')
							.form_input(array('name'=>'en_key','id'=>'en_key')).'<br/>'
							.form_label('Privileged SQL User: ','sa_name')
							.form_input(array('name'=>'sa_name','id'=>'sa_name')).'<br/>'
							.form_label('Privileged SQL User Password: ','sa_pwd')
							.form_password(array('name'=>'sa_pwd','id'=>'sa_pwd')).'<br/>'
							.form_submit('encrypt_db','Encrypt Database')
							.form_close();
			}
			else { //database is not encrypted
				$output .= '<h4>Database Encryption Status: Unknown / Not Encrypted</h4>';
				$output .= form_open('install/encrypt_db/'.$database)
						.form_label('Encryption Key','en_key')
						.form_input(array('name'=>'en_key','id'=>'en_key')).'<br/>'
						.form_submit('encrypt_db','Encrypt Database')
						.form_close();
			}
		}
		else if($database === MAIL_DATABASE_NAME && $db_encrypted){
			$output .= '<h4>Database Encryption Status: Encrypted</h4>';
		}
		
		//if the database already exists, and the configured user has permissions needed for running the app 
		//NOTE: permissions checking checks roles only, not all permissions, user may still not be able to create tables
		if($db_connected && $db_exists && $permissions_set) {
			$this->load->database();
			if($this->db->database !== $database) {
				$config['hostname'] = DATABASE_HOSTNAME;
				$config['username'] = DATABASE_USERNAME;
				$config['password'] = DATABASE_PASSWORD;
				$config['database'] = $database;
				$config['dbdriver'] = DATABASE_DRIVER;
				$config['dbprefix'] = '';
				$config['pconnect'] = FALSE;
				$config['db_debug'] = FALSE;
				$config['cache_on'] = FALSE;
				$config['cachedir'] = '';
				$config['char_set'] = 'utf8';
				$config['dbcollat'] = 'utf8_general_ci';
				$config['swap_pre'] = '';
				$config['autoinit'] = FALSE;
				$config['stricton'] = FALSE;
				$db = $this->load->database($config,TRUE);
				$this->db = $db;
			}
			foreach($this->databases[$database] as $table => $columns) {
				$errors = $this->session->flashdata($table.'_errors');
				$query = $this->session->flashdata($table.'_query');
				if($errors) {
					if(is_array($errors)) {
						foreach($errors as $error) {
							$output .= '<div style="max-width: 1000px; background: #fef1ec; border: solid 1px #900; border-radius: 5px; padding: 5px; margin-bottom: 5px;">'.$error['message'].'</div>';
						}
					}
				}
				//TABLE START
				$output .= '<table style="border: solid black 1px; border-collapse: collapse; margin-right: 15px; margin-bottom: 15px; width: 400px;">';
				
				$tbl_check_query = 'SELECT * FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_TYPE='.$this->db->escape('BASE TABLE').' AND TABLE_NAME='.$this->db->escape($table);
				$tbl_check = $this->db->query($tbl_check_query);
				//query to check table existence works
				if($tbl_check) {
					//if the table does not exist
					if($tbl_check->num_rows() <= 0) {
						//check for errors from a previously run query
						if(isset($errors) && (is_array($errors) || is_object($errors)) && $errors) {
							$permission_issue = FALSE;
							foreach($errors as $error) {
								if(strpos('permission denied', $error['message']) >= 0) { $permission_issue = TRUE; }
							}
							//if there was a permissions issue, offer a way to enter better credentials
							if($permission_issue) {
								$output .= '<tr><td>A permissions issue was detected with the query, if more privileged credentials are available, enter them below.'
												.form_open('install/create_db_table/'.$table.'/'.$database)
												.form_label('Privileged SQL User: ','sa_name')
												.form_input(array('name'=>'sa_name','id'=>'sa_name')).'<br/>'
												.form_label('Privileged SQL User Password: ','sa_pwd')
												.form_password(array('name'=>'sa_pwd','id'=>'sa_pwd')).'<br/>'
												.form_submit('create_'.$table,'Create '.$table)
												.form_close().'</td></tr>';
							}
							//but also give the query to run manually through SQL Management Studio
							//should pull query from flashdata if possible to ensure it is the right one, but if that isn't possible use the hardcoded one for create table
							if(!isset($query) || !$query) {
								$query = $this->database_table_queries[$database]['create_'.$table];
							}
							$output .= '<tr><td>To manually create table <span style="font-weight: bold;">' . $table . '</span> table use the following query:</td></tr>';
							$output .= '<tr><td><pre style="background: #eee; width: 1000px; word-wrap: break-word;">' . preg_replace('/[\t]+/',' ',$query) . '</pre></td></tr>';
						}
						else {
							$output .= '<tr><th title="'.$table.' does not exist" style="color: red;">' . $table . '</th></tr>';
							$output .= '<tr><td style="text-align: center;">'.form_open('install/create_db_table/'.$table.'/'.$database).form_submit('create_'.$table,'Create '.$table).form_close().'</td></tr>';
						}
					}
					//if it does exist
					else {
						$output .= '<tr><th style="color: green;">' . $table . '</th><th>Status</th></tr>';
						foreach($columns as $column => $type) {
							$col_check_query = 'SELECT * FROM sys.columns WHERE [name] = N'.$this->db->escape($column).' AND object_id = OBJECT_ID(N'.$this->db->escape($table).')';
							$col_check = $this->db->query($col_check_query);
							if($col_check) {
								$output .= '<tr>';
								if($col_check->num_rows() <= 0) {
									$output .= '<td style="color: red;">'.$column.' ['.$type.']</td>';
									$output .= '<td style="color: red; text-align: center;">&#x2717;</td>';
								}
								else {
									$output .= '<td style="color: green;">'.$column.' ['.$type.']</td>';
									$data_type_query = 'SELECT DATA_TYPE, CHARACTER_MAXIMUM_LENGTH FROM INFORMATION_SCHEMA.COLUMNS IC WHERE TABLE_NAME='.$this->db->escape($table).' AND COLUMN_NAME='.$this->db->escape($column);
									$data_type_check = $this->db->query($data_type_query);
									if($data_type_check) {
										if($col_check->num_rows() <= 0) {
										
										}
										else {
											$result = $data_type_check->result_array(0);
											$data_type = $result[0]['DATA_TYPE'];
											$max_length = ($result[0]['CHARACTER_MAXIMUM_LENGTH'] === -1) ? 'max' : $result[0]['CHARACTER_MAXIMUM_LENGTH'];
											if($data_type === $type || $data_type.'('.$max_length.')' === $type) {
												$output .= '<td style="color: green; text-align: center;">&#x2713;</td>';
											}
											else {
												$fix_col_query = 'ALTER TABLE '.$table.' ALTER COLUMN '.$column.' '.$type;
												$output .= '<td title="Data Type Mismatch. Click for alter column query." onclick="alert(&quot;'.$fix_col_query.'&quot;);" style="text-align: center; background: #fee; border: solid #f00 1px;"><span style="color: red;">&#x2717;</span></td>';
											}
										}
									}
								}
							}
							else { 
								$output .= '<td style="color: gold;">'.$column.' ['.$type.']</td>';
								$output .= '<td title="Click for manual column existence check query." onclick="alert(&quot;'.$col_check_query.'&quot;);" style="text-align: center; cursor: pointer;"><span style="color: gold;">&#x26a0;</span> Query Failed</td>'; 
							}
							$output .= '</tr>';
						}
					}
				}
				//if query fails, may not have the proper permissions
				else {
					$output .= '<tr><th style="color: gold; text-align: center;">&#x26a0; Database Check Failed</th></tr>';
					$output .= '<tr><td>Manually execute query below to check existence of <span style="font-weight: bold;">'.$table.'</span> table:</td></tr>';
					$output .= '<tr><td><pre>'.$tbl_check_query.'</pre></td></tr>';
				}
				//TABLE END
				$output .= '</table>';
			}
		}
		return $output;
	}
	
	public function create_ldap() {
				
	}
	
	public function create_ldap_entry($dn) {
		$dn = base64_decode(rawurldecode($dn));
		if(array_key_exists($dn, $this->ldap_schema)) {
			$this->_create_ldap_entry($dn);
		}
		redirect('install/ldap');
	}
	
	private function _create_ldap_entry($dn) {
		$ldap_conn = $this->prepare_ldap_conn();
		$ldap_bind = @ldap_bind($ldap_conn, LDAP_ANON_ADMIN_USERNAME, LDAP_ANON_ADMIN_PASSWORD);
		if($ldap_bind) {
			ldap_add($ldap_conn, $dn, $this->ldap_schema[$dn]);
		}
		else {
		
		}
	}
	
	private function ldap_entry_exists($ldap_conn,$dn) {
		$search = @ldap_search($ldap_conn, $dn, '(objectClass=*)');
		$result = @ldap_get_entries($ldap_conn,$search);
		if($result['count'] > 0) { return TRUE; }
		return FALSE;
	}
	private function prepare_ldap_conn() {
		$ldap_conn = ldap_connect(LDAP_HOSTNAME, LDAP_PORT);
		if(!ldap_set_option($ldap_conn, LDAP_OPT_PROTOCOL_VERSION, 3)) { return FALSE; } 
		if(!ldap_set_option($ldap_conn, LDAP_OPT_REFERRALS, 0)) { return FALSE; }
		return $ldap_conn;
	}
	
}
